/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.mojang.datafixers.util.Pair;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class ConsumableDecorativeBlock
extends DecorativeBlock {
    public static final IntegerProperty BITES = ModBlockStateProperties.BITES;
    private final int bites;
    private final ConsumeAction finishedAction;
    private final ConsumeAction eatAction;
    private final Supplier<ItemStack> plate;
    private final FoodProperties food;
    public static ConsumeAction DEFAULT_FINISH_ACTION = (pState, pLevel, pPos, pPlayer) -> {
        ItemStack itemStack;
        pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
        Block patt1818$temp = pState.m_60734_();
        if (patt1818$temp instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)patt1818$temp;
            itemStack = consumable.getPlate();
        } else {
            itemStack = ItemStack.f_41583_;
        }
        ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)itemStack);
        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157794_, pPos);
    };
    public static ConsumeAction DEFAULT_EAT_ACTION = (pState, pLevel, pPos, pPlayer) -> {
        Block patt2106$temp = pState.m_60734_();
        if (patt2106$temp instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)patt2106$temp;
            FoodProperties food = consumable.getFood();
            pPlayer.m_36324_().m_38707_(food.m_38744_(), food.m_38745_());
            for (Pair pair : food.m_38749_()) {
                if (pLevel.f_46443_ || pair.getFirst() == null || !(pLevel.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                pPlayer.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
            pLevel.m_5594_(pPlayer, pPos, SoundEvents.f_11912_, SoundSource.PLAYERS, 1.0f, 0.75f);
            pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157806_, pPos);
        }
    };

    public ConsumableDecorativeBlock(Builder builder) {
        super(builder);
        this.bites = builder.bites;
        this.finishedAction = builder.finishedAction;
        this.eatAction = builder.eatAction;
        this.plate = builder.plate;
        this.food = builder.food;
        this.m_49959_((BlockState)((BlockState)this.stateDefinition.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(this.bites)));
    }

    public static Builder with(BaseBlockProperty property) {
        return new Builder(property);
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = super.m_5573_(pContext);
        return state.m_61138_((Property)BITES) ? (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(this.getMaxBites())) : state;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int bitesRemaining;
        int n = bitesRemaining = pState.m_61138_((Property)BITES) ? (Integer)pState.m_61143_((Property)BITES) : 0;
        if (!pPlayer.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        if (bitesRemaining > 0) {
            this.eatAction.consume(pState, pLevel, pPos, pPlayer);
            --bitesRemaining;
        }
        if (bitesRemaining <= 0) {
            this.finishedAction.consume(pState, pLevel, pPos, pPlayer);
        } else {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bitesRemaining)), 3);
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    public int getMaxBites() {
        return this.bites;
    }

    public ItemStack getPlate() {
        return this.plate.get();
    }

    public FoodProperties getFood() {
        return this.food;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{BITES});
    }

    public static class Builder
    extends DecorativeBlock.Builder {
        private static final FoodProperties DEFAULT_FOOD = new FoodProperties.Builder().m_38760_(2).m_38758_(0.2f).m_38767_();
        private int bites = 4;
        private Supplier<ItemStack> plate = () -> new ItemStack((ItemLike)Blocks.f_50404_);
        private ConsumeAction eatAction = DEFAULT_EAT_ACTION;
        private ConsumeAction finishedAction = DEFAULT_FINISH_ACTION;
        private FoodProperties food = DEFAULT_FOOD;

        public Builder(BaseBlockProperty property) {
            super(property);
        }

        public Builder bites(int bites) {
            this.bites = bites;
            return this;
        }

        public Builder whenFinished(ConsumeAction action) {
            this.finishedAction = action;
            return this;
        }

        public Builder onEat(ConsumeAction action) {
            this.eatAction = action;
            return this;
        }

        public Builder platedWith(ItemStack plate) {
            this.plate = () -> plate;
            return this;
        }

        public Builder platedWith(Block plate) {
            this.plate = () -> new ItemStack((ItemLike)plate);
            return this;
        }

        public Builder platedWith(Supplier<Item> plate) {
            this.plate = () -> new ItemStack((ItemLike)plate.get());
            return this;
        }

        public Builder food(FoodProperties food) {
            this.food = food;
            return this;
        }

        @Override
        public ConsumableDecorativeBlock build() {
            return new ConsumableDecorativeBlock(this);
        }
    }

    @FunctionalInterface
    public static interface ConsumeAction {
        public void consume(BlockState var1, Level var2, BlockPos var3, Player var4);
    }
}

